/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.skill;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.client.screen.skill.IViewContext;
import dev.toma.gunsrpg.client.screen.skill.IViewManager;
import dev.toma.gunsrpg.client.screen.skill.SkillTrees;
import dev.toma.gunsrpg.client.screen.skill.SkillsView;
import dev.toma.gunsrpg.client.screen.skill.View;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.skills.core.SkillCategory;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class SkillTreeScreen
extends Screen
implements IViewContext {
    private static final ITextComponent TITLE = new TranslationTextComponent("screen.skill_tree");
    private final IViewManager manager = new ViewManager();
    private IPlayerData data;

    public SkillTreeScreen() {
        super(TITLE);
        this.queryCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_231160_c_() {
        this.data = (IPlayerData)PlayerData.get((PlayerEntity)this.field_230706_i_.field_71439_g).orElseThrow(NullPointerException::new);
        MainWindow window = this.field_230706_i_.func_228018_at_();
        View view = this.manager.getView();
        if (view == null) {
            view = new SkillsView(this.field_230708_k_, this.field_230709_l_, this.manager);
            this.manager.setView(view);
        }
        this.func_230481_d_((IGuiEventListener)view);
        view.resizeFor(window);
        Object object = view.lock;
        synchronized (object) {
            view.init();
        }
    }

    @Override
    public IPlayerData getData() {
        return this.data;
    }

    public void func_231023_e_() {
        this.manager.getView().tick();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.manager.getView().func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void queryCache() {
        if (Cache.hasBeenBuilt()) {
            this.updateView();
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> Cache.buildCacheAsync()).exceptionally(x$0 -> Cache.onBuildFailed(x$0))).thenAccept(this::onSkillTreeReady);
    }

    private void updateView() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.setView(new SkillsView(window.func_198107_o(), window.func_198087_p(), this.manager));
    }

    private void onSkillTreeReady(Map<SkillCategory, SkillTrees> result) {
        Cache.onBuildFinished(result);
        if (this.manager.getView() instanceof SkillsView) {
            ((SkillsView)this.manager.getView()).loadTree();
        }
    }

    private void setView(View view) {
        this.manager.setView(view);
    }

    private void updateWidgets() {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow window = mc.func_228018_at_();
        this.func_231158_b_(mc, window.func_198107_o(), window.func_198087_p());
    }

    public static final class Cache {
        private static final Marker MARKER = MarkerManager.getMarker((String)"SkillCache");
        private static Map<SkillCategory, SkillTrees> treeMap;

        public static void invalidate() {
            treeMap = null;
        }

        public static boolean hasBeenBuilt() {
            return treeMap != null;
        }

        public static Map<SkillCategory, SkillTrees> queryData() {
            return treeMap;
        }

        private static Map<SkillCategory, SkillTrees> buildCacheAsync() {
            GunsRPG.log.debug(MARKER, "Starting skill placement cache build.");
            long time = System.currentTimeMillis();
            EnumMap<SkillCategory, SkillTrees> result = new EnumMap<SkillCategory, SkillTrees>(SkillCategory.class);
            Map<SkillCategory, List<SkillType<?>>> data = ModUtils.SKILLS_BY_CATEGORY.split((Iterable<SkillType<?>>)ModRegistries.SKILLS);
            for (Map.Entry<SkillCategory, List<SkillType<?>>> entry : data.entrySet()) {
                SkillCategory category = entry.getKey();
                List<SkillType<?>> skillTypes = entry.getValue();
                SkillTrees trees = new SkillTrees(category);
                trees.populate(skillTypes);
                result.put(category, trees);
            }
            GunsRPG.log.debug(MARKER, "Skill tree cache has been built after {} ms", (Object)(System.currentTimeMillis() - time));
            return result;
        }

        private static Map<SkillCategory, SkillTrees> onBuildFailed(Throwable throwable) {
            GunsRPG.log.fatal(MARKER, "Skill placement cache build failed, no skills can be displayed. ", throwable);
            return null;
        }

        private static void onBuildFinished(Map<SkillCategory, SkillTrees> result) {
            treeMap = result;
        }
    }

    public class ViewManager
    implements IViewManager {
        private View view;

        @Override
        public IViewContext getContext() {
            return SkillTreeScreen.this;
        }

        @Override
        public void setView(View view) {
            this.view = view;
            SkillTreeScreen.this.updateWidgets();
        }

        @Override
        public View getView() {
            return this.view;
        }

        @Override
        public int getWidth() {
            return SkillTreeScreen.this.field_230708_k_;
        }

        @Override
        public int getHeight() {
            return SkillTreeScreen.this.field_230709_l_;
        }
    }
}

